do

-- Define a SET_GROUP object that builds a collection of groups that define the EWR network.
DetectionSetGroup = SET_GROUP:New()
-- DetectionSetGroup:FilterPrefixes( { "EW", "AWACS" } )
-- DetectionSetGroup:FilterStart()

-- add the MOOSE SET_GROUP to the Skynet IADS, from now on Skynet will update active radars that the MOOSE SET_GROUP can use for EW detection.
iranIADS:addMooseSetGroup(DetectionSetGroup)

-- Setup the detection and group targets to a 30km range!
Detection = DETECTION_AREAS:New( DetectionSetGroup, 30000 )

-- Setup the A2A dispatcher, and initialize it.
A2ADispatcher = AI_A2A_DISPATCHER:New( Detection )

-- Set 100km as the radius to engage any target by airborne friendlies.
A2ADispatcher:SetEngageRadius( 130000 ) -- 100000 is the default value.

-- Set 200km as the radius to ground control intercept.
A2ADispatcher:SetGciRadius( 180000 ) -- 200000 is the default value.

CCCPBorderZone = ZONE_POLYGON:New( "RED BORDER", GROUP:FindByName( "RED BORDER" ) )
A2ADispatcher:SetBorderZone( CCCPBorderZone )

A2ADispatcher:SetSquadron( "Lar", AIRBASE.PersianGulf.Lar_Airbase, { "SQ MiG-21bis R3S", "SQ MiG-21bis R60" }, 10 )
A2ADispatcher:SetSquadronGrouping( "Lar", 2 )
A2ADispatcher:SetSquadronGci( "Lar", 800, 1200 )
A2ADispatcher:SetSquadronOverhead( "Lar", 1.5 )
A2ADispatcher:SetSquadronLanguage( "Lar", "RU" ) -- This squadron speaks Russian.

A2ADispatcher:SetSquadronTakeoffInAir( "Lar", 4500 ) -- Takeoff in Lar_Airbase at 4000 meters.
A2ADispatcher:SetSquadronLandingNearAirbase( "Lar" )

A2ADispatcher:SetSquadron( "Qeshm", AIRBASE.PersianGulf.Qeshm_Island, { "SQ MiG-19P farmer K13A", "SQ MiG-19P farmer C" }, 10 )
A2ADispatcher:SetSquadronGrouping( "Qeshm", 2 )
A2ADispatcher:SetSquadronGci( "Qeshm", 770, 1100 )
A2ADispatcher:SetSquadronOverhead( "Qeshm", 1.5 )
A2ADispatcher:SetSquadronLanguage( "Qeshm", "RU" ) -- This squadron speaks Russian.

A2ADispatcher:SetSquadronTakeoffInAir( "Qeshm", 4500 ) -- Takeoff in Qeshm_Island at 4000 meters.
A2ADispatcher:SetSquadronLandingNearAirbase( "Qeshm" )

A2ADispatcher:SetSquadron( "Jiroft", AIRBASE.PersianGulf.Jiroft_Airport, { "SQ MiG-29S R-77", "SQ MiG-29S R-27R" }, 8 )
A2ADispatcher:SetSquadronGrouping( "Jiroft", 2 )
A2ADispatcher:SetSquadronGci( "Jiroft", 800, 1200 )
A2ADispatcher:SetSquadronOverhead( "Jiroft", 1.5 )
A2ADispatcher:SetSquadronLanguage( "Jiroft", "RU" ) -- This squadron speaks Russian.

A2ADispatcher:SetSquadronTakeoffInAir( "Jiroft", 4500 ) -- Takeoff in Qeshm_Island at 4000 meters.
A2ADispatcher:SetSquadronLandingNearAirbase( "Jiroft" )

A2ADispatcher:SetSquadron( "Bandar_e_Jask", AIRBASE.PersianGulf.Bandar_e_Jask_airfield, { "SQ J-11A R-27ET", "SQ J-11A R-27ER" }, 8 )
A2ADispatcher:SetSquadronGrouping( "Bandar_e_Jask", 2 )
A2ADispatcher:SetSquadronGci( "Bandar_e_Jask", 800, 1200 )
A2ADispatcher:SetSquadronLanguage( "Bandar_e_Jask", "RU" ) -- This squadron speaks Russian.

A2ADispatcher:SetSquadronTakeoffInAir( "Bandar_e_Jask", 5000 ) -- Takeoff in Qeshm_Island at 4000 meters.
A2ADispatcher:SetSquadronLandingNearAirbase( "Bandar_e_Jask" )


A2ADispatcher:SetSquadron( "Kerman", AIRBASE.PersianGulf.Kerman_Airport, { "SQ F-14A AIM-7M Kerman", "SQ F-14A AIM-54A Kerman" }, 8 )
A2ADispatcher:SetSquadronGrouping( "Kerman", 2 )
A2ADispatcher:SetSquadronLanguage( "Kerman", "RU" ) -- This squadron speaks Russian.

A2ADispatcher:SetSquadronTakeoffFromRunway( "Kerman" ) -- Takeoff from Kerman_Airport runway HOT.
A2ADispatcher:SetSquadronLandingAtEngineShutdown( "Kerman" )

A2ADispatcher:SetSquadron( "Shiraz", AIRBASE.PersianGulf.Shiraz_International_Airport, { "SQ SU-27 R-27ER Shiraz", "SQ SU-27 R-27ET Shiraz" }, 8 )
A2ADispatcher:SetSquadronGrouping( "Shiraz", 2 )
A2ADispatcher:SetSquadronLanguage( "Shiraz", "RU" ) -- This squadron speaks Russian.

A2ADispatcher:SetSquadronTakeoffFromParkingCold( "Shiraz" ) -- Takeoff from Kerman_Airport parking cold.
A2ADispatcher:SetSquadronLandingAtEngineShutdown( "Shiraz" )


A2ADispatcher:SetSquadron( "Bandar_Abbas", AIRBASE.PersianGulf.Bandar_Abbas_Intl, { "SQ M-2000C S530D Bandar_Abbas", "SQ M-2000C Magicll Bandar_Abbas" }, 8 )
A2ADispatcher:SetSquadronGrouping( "Bandar_Abbas", 2 )


A2ADispatcher:SetSquadronTakeoffFromRunway( "Bandar_Abbas" ) -- Takeoff from Bandar_Abbas runway HOT.
A2ADispatcher:SetSquadronLandingAtEngineShutdown( "Bandar_Abbas" )


-- CAP Squadron execution.
CAPZoneKerman = ZONE_POLYGON:New( "CAP ZONE Kerman", GROUP:FindByName( "CAP ZONE Kerman" ) )
A2ADispatcher:SetSquadronCap( "Kerman", CAPZoneKerman, 6000, 12000, 700, 900, 700, 1200, "BARO" )
A2ADispatcher:SetSquadronCapInterval( "Kerman", 1, 120, 420, 1 )

CAPZoneShiraz = ZONE_POLYGON:New( "CAP ZONE Shiraz", GROUP:FindByName( "CAP ZONE Shiraz" ) )
A2ADispatcher:SetSquadronCap( "Shiraz", CAPZoneShiraz, 6000, 12000, 800, 1000, 800, 1400, "BARO" )
A2ADispatcher:SetSquadronCapInterval( "Shiraz", 1, 120, 420, 1 )

CAPZoneShiraz = ZONE_POLYGON:New( "CAP ZONE Bandar Abbas Intl", GROUP:FindByName( "CAP ZONE Bandar Abbas Intl" ) )
A2ADispatcher:SetSquadronCap( "Bandar_Abbas", CAPZoneShiraz, 6000, 12000, 800, 1000, 800, 1400, "BARO" )
A2ADispatcher:SetSquadronCapInterval( "Bandar_Abbas", 1, 120, 420, 1 )



A2ADispatcher:SetDefaultCapTimeInterval( 300, 1200 ) -- Between 300 and 1200 seconds.
A2ADispatcher:SetDefaultGrouping( 2 )
A2ADispatcher:SetDefaultTakeoffInAir()
A2ADispatcher:SetDefaultLandingNearAirbase()
A2ADispatcher:SetDefaultTakeoffInAirAltitude( 4000 )
A2ADispatcher:SetDefaultFuelThreshold( 0.3 )
A2ADispatcher:SetDefaultDamageThreshold( 0.3 ) -- Go RTB when the airplane 90% damaged.
A2ADispatcher:SetDisengageRadius( 240000 ) -- 300000 is the default value.
A2ADispatcher:SetTacticalDisplay(true)
A2ADispatcher:Start()


end
